"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useWindowScroll_1 = __importDefault(require("./useWindowScroll"));
var useWindowResize_1 = __importDefault(require("./useWindowResize"));
var useThrottledCallback_1 = __importDefault(require("./useThrottledCallback"));
var useDidMount_1 = __importDefault(require("./useDidMount"));
/**
 * Returns updated information on the current viewport state
 */
var useViewportState = function (debounceBy) {
    if (debounceBy === void 0) { debounceBy = 250; }
    var _a = (0, react_1.useState)({ width: 0, height: 0, scrollY: 0, scrollX: 0 }), viewport = _a[0], setViewport = _a[1];
    var onScroll = (0, useWindowScroll_1.default)();
    var onResize = (0, useWindowResize_1.default)();
    var onMount = (0, useDidMount_1.default)();
    var saveInfo = (0, useThrottledCallback_1.default)(function () {
        setViewport({
            width: window.innerWidth,
            height: window.innerHeight,
            scrollX: window.scrollX,
            scrollY: window.scrollY
        });
    }, [setViewport], debounceBy);
    onScroll(saveInfo);
    onResize(saveInfo);
    onMount(saveInfo);
    return viewport;
};
exports.default = useViewportState;
