"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var distinctValues = function (value, current, array) { return array.indexOf(value) === current; };
/**
 * Accepts a variable (possibly a prop or a state) and returns its history (changes through updates).
 */
var useValueHistory = function (value, distinct) {
    if (distinct === void 0) { distinct = false; }
    var history = (0, react_1.useRef)([]);
    // quite simple
    (0, react_1.useEffect)(function () {
        history.current.push(value);
        if (distinct) {
            history.current = history.current.filter(distinctValues);
        }
    }, [value]);
    return history.current;
};
exports.default = useValueHistory;
