/**
 * Returns a state that changes only if the next value pass its validator
 */
declare const useValidatedState: <TValue, TValidator extends Validator<TValue>>(validator: TValidator, initialValue?: TValue | undefined) => [TValue, (nextValue: TValue) => void, ValidationResult];
export type Validator<TValue> = (value: TValue) => boolean;
export interface ValidationResult {
    changed: boolean;
    valid?: boolean;
}
export default useValidatedState;
