"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useIsFirstRender_1 = __importDefault(require("./useIsFirstRender"));
/**
 * A hook that runs an effect after the first render.
 * @param callback
 * @param deps
 */
var useUpdateEffect = function (callback, deps) {
    var isFirstRender = (0, useIsFirstRender_1.default)();
    (0, react_1.useEffect)(function () {
        if (!isFirstRender) {
            return callback();
        }
        return undefined;
    }, deps);
};
exports.default = useUpdateEffect;
