"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var useTouchEvents_1 = __importDefault(require("./useTouchEvents"));
var useTouchState_1 = __importDefault(require("./useTouchState"));
/**
 * Returns an array where the first item is the touch state from the `useTouchState` hook and the second item
 * is the object of callback setters from the `useTouchEvents` hook.
 * It is intended as a shortcut to those hooks.
 */
var useTouch = function (targetRef) {
    if (targetRef === void 0) { targetRef = undefined; }
    var state = (0, useTouchState_1.default)(targetRef);
    var events = (0, useTouchEvents_1.default)(targetRef);
    return [state, events];
};
exports.default = useTouch;
