import { type RefObject } from 'react';
import { type UseTouchEventsReturn } from './useTouchEvents';
/**
 * Returns an array where the first item is the touch state from the `useTouchState` hook and the second item
 * is the object of callback setters from the `useTouchEvents` hook.
 * It is intended as a shortcut to those hooks.
 */
declare const useTouch: <TElement extends HTMLElement>(targetRef?: RefObject<TElement> | undefined) => [TouchList, Readonly<UseTouchEventsReturn>];
export default useTouch;
