"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var lodash_throttle_1 = __importDefault(require("lodash.throttle"));
var useWillUnmount_1 = __importDefault(require("./useWillUnmount"));
var defaultOptions = {
    leading: false,
    trailing: true
};
/**
 * Accepts a function and returns a new throttled yet memoized version of that same function that waits the defined time
 * before allowing the next execution.
 * If time is not defined, its default value will be 250ms.
 */
var useThrottledCallback = function (fn, dependencies, wait, options) {
    if (wait === void 0) { wait = 600; }
    if (options === void 0) { options = defaultOptions; }
    var throttled = (0, react_1.useRef)((0, lodash_throttle_1.default)(fn, wait, options));
    (0, react_1.useEffect)(function () {
        throttled.current = (0, lodash_throttle_1.default)(fn, wait, options);
    }, [fn, wait, options]);
    (0, useWillUnmount_1.default)(function () {
        var _a;
        (_a = throttled.current) === null || _a === void 0 ? void 0 : _a.cancel();
    });
    return (0, react_1.useCallback)(throttled.current, dependencies !== null && dependencies !== void 0 ? dependencies : []);
};
exports.default = useThrottledCallback;
