"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var isFunction_1 = __importDefault(require("./shared/isFunction"));
var useMouseEvents_1 = __importDefault(require("./useMouseEvents"));
var useTouchEvents_1 = __importDefault(require("./useTouchEvents"));
var createHandlerSetter_1 = __importDefault(require("./factory/createHandlerSetter"));
var swipeUtils_1 = require("./shared/swipeUtils");
var defaultOptions = {
    threshold: 15,
    preventDefault: true,
    passive: undefined
};
/* eslint-disable @typescript-eslint/default-param-last */
/**
 * Very similar to useSwipe but doesn't cause re-rendering during swipe.
 * Internal usage only.
 */
var useSwipeStateInternal = function (targetRef, options, onSwipeStart, onSwipeMove, onSwipeEnd) {
    if (targetRef === void 0) { targetRef = undefined; }
    if (options === void 0) { options = defaultOptions; }
    var startingPointRef = (0, react_1.useRef)([-1, -1]);
    var directionRef = (0, react_1.useRef)(null);
    var isDraggingRef = (0, react_1.useRef)(false);
    var alphaRef = (0, react_1.useRef)([]);
    var opts = __assign(__assign({}, defaultOptions), (options || {}));
    var _a = (0, useMouseEvents_1.default)(targetRef, opts.passive), onMouseDown = _a.onMouseDown, onMouseMove = _a.onMouseMove, onMouseLeave = _a.onMouseLeave, onMouseUp = _a.onMouseUp;
    var _b = (0, useTouchEvents_1.default)(targetRef, opts.passive), onTouchStart = _b.onTouchStart, onTouchMove = _b.onTouchMove, onTouchEnd = _b.onTouchEnd, onTouchCancel = _b.onTouchCancel;
    var _c = (0, react_1.useState)(), state = _c[0], setState = _c[1];
    var startSwipe = function (event) {
        var _a = (0, swipeUtils_1.getPointerCoordinates)(event), clientX = _a[0], clientY = _a[1];
        startingPointRef.current = [clientX, clientY];
        directionRef.current = null;
        if (onSwipeStart) {
            onSwipeStart({ clientX: clientX, clientY: clientY });
        }
        if (opts.preventDefault) {
            event.preventDefault();
            event.stopPropagation();
        }
    };
    var continueSwipe = function (event) {
        var _a = (0, swipeUtils_1.getPointerCoordinates)(event), clientX = _a[0], clientY = _a[1];
        if (opts.preventDefault) {
            event.preventDefault();
            event.stopPropagation();
        }
        if (startingPointRef.current[0] !== -1 && startingPointRef.current[1] !== -1) {
            var alpha = [startingPointRef.current[0] - clientX, startingPointRef.current[1] - clientY];
            if (Math.abs(alpha[0]) > opts.threshold || Math.abs(alpha[1]) > opts.threshold) {
                isDraggingRef.current = true;
                directionRef.current = (0, swipeUtils_1.getDirection)([clientX, clientY], startingPointRef.current, alpha);
                alphaRef.current = alpha;
                if (onSwipeMove) {
                    onSwipeMove({
                        clientX: clientX,
                        clientY: clientY,
                        direction: directionRef.current,
                        alphaX: alphaRef.current[0],
                        alphaY: alphaRef.current[1]
                    });
                }
            }
        }
    };
    var endSwipe = function (event) {
        if (isDraggingRef.current && directionRef.current) {
            if (opts.preventDefault) {
                event.preventDefault();
                event.stopPropagation();
            }
            setState({
                direction: directionRef.current,
                alphaX: alphaRef.current[0],
                alphaY: alphaRef.current[1]
            });
            if (onSwipeEnd) {
                onSwipeEnd({
                    direction: directionRef.current,
                    alphaX: alphaRef.current[0],
                    alphaY: alphaRef.current[1]
                });
            }
        }
        startingPointRef.current = [-1, -1];
        isDraggingRef.current = false;
        directionRef.current = null;
    };
    onMouseDown(startSwipe);
    onTouchStart(startSwipe);
    onMouseMove(continueSwipe);
    onTouchMove(continueSwipe);
    onMouseUp(endSwipe);
    onTouchEnd(endSwipe);
    onMouseLeave(endSwipe);
    onTouchCancel(endSwipe);
    return state;
};
/**
 * useSwipeEvents
 * @param ref
 * @param options
 */
// eslint-disable-next-line max-len
var useSwipeEvents = function (ref, options) {
    if (ref === void 0) { ref = undefined; }
    if (options === void 0) { options = defaultOptions; }
    var opts = __assign(__assign({}, defaultOptions), (options || {}));
    var _a = (0, createHandlerSetter_1.default)(), onSwipeLeft = _a[0], setOnSwipeLeft = _a[1];
    var _b = (0, createHandlerSetter_1.default)(), onSwipeRight = _b[0], setOnSwipeRight = _b[1];
    var _c = (0, createHandlerSetter_1.default)(), onSwipeUp = _c[0], setOnSwipeUp = _c[1];
    var _d = (0, createHandlerSetter_1.default)(), onSwipeDown = _d[0], setOnSwipeDown = _d[1];
    var _e = (0, createHandlerSetter_1.default)(), onSwipeStart = _e[0], setOnSwipeStart = _e[1];
    var _f = (0, createHandlerSetter_1.default)(), onSwipeMove = _f[0], setOnSwipeMove = _f[1];
    var _g = (0, createHandlerSetter_1.default)(), onSwipeEnd = _g[0], setOnSwipeEnd = _g[1];
    var state = useSwipeStateInternal(ref, opts, onSwipeStart.current, onSwipeMove.current, onSwipeEnd.current);
    var fnMap = {
        right: onSwipeRight,
        left: onSwipeLeft,
        up: onSwipeUp,
        down: onSwipeDown
    };
    (0, react_1.useEffect)(function () {
        if (state === null || state === void 0 ? void 0 : state.direction) {
            var cb = fnMap[state.direction].current;
            if ((0, isFunction_1.default)(cb)) {
                cb(state);
            }
        }
    }, [state]);
    return Object.freeze({
        onSwipeLeft: setOnSwipeLeft,
        onSwipeRight: setOnSwipeRight,
        onSwipeUp: setOnSwipeUp,
        onSwipeDown: setOnSwipeDown,
        onSwipeMove: setOnSwipeMove,
        onSwipeStart: setOnSwipeStart,
        onSwipeEnd: setOnSwipeEnd
    });
};
exports.default = useSwipeEvents;
