"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var swipeUtils_1 = require("./shared/swipeUtils");
var useMouseEvents_1 = __importDefault(require("./useMouseEvents"));
var useTouchEvents_1 = __importDefault(require("./useTouchEvents"));
var initialState = { swiping: false, direction: undefined, alphaX: 0, alphaY: 0, count: 0 };
var defaultOptions = {
    direction: 'both',
    threshold: 10,
    preventDefault: true,
    passive: undefined
};
var isEqual = function (prev, next) { return (prev.swiping === next.swiping &&
    prev.direction === next.direction &&
    prev.count === next.count &&
    prev.alphaX === next.alphaX &&
    prev.alphaY === next.alphaY); };
/**
 * useSwipe hook
 */
var useSwipe = function (targetRef, options) {
    if (targetRef === void 0) { targetRef = undefined; }
    if (options === void 0) { options = defaultOptions; }
    var _a = (0, react_1.useState)(initialState), state = _a[0], setState = _a[1];
    var startingPointRef = (0, react_1.useRef)([-1, -1]);
    var isDraggingRef = (0, react_1.useRef)(false);
    var opts = __assign(__assign({}, defaultOptions), (options || {}));
    var _b = (0, useMouseEvents_1.default)(targetRef, opts.passive), onMouseDown = _b.onMouseDown, onMouseMove = _b.onMouseMove, onMouseLeave = _b.onMouseLeave, onMouseUp = _b.onMouseUp;
    var _c = (0, useTouchEvents_1.default)(targetRef, opts.passive), onTouchStart = _c.onTouchStart, onTouchMove = _c.onTouchMove, onTouchEnd = _c.onTouchEnd, onTouchCancel = _c.onTouchCancel;
    var startSwipe = function (event) {
        var _a = (0, swipeUtils_1.getPointerCoordinates)(event), clientX = _a[0], clientY = _a[1];
        startingPointRef.current = [clientX, clientY];
        if (opts.preventDefault) {
            event.preventDefault();
            event.stopPropagation();
        }
    };
    var continueSwipe = function (event) {
        var _a = (0, swipeUtils_1.getPointerCoordinates)(event), clientX = _a[0], clientY = _a[1];
        if (opts.preventDefault) {
            event.preventDefault();
            event.stopPropagation();
        }
        if (isDraggingRef.current || (startingPointRef.current[0] !== -1 && startingPointRef.current[1] !== -1)) {
            var alpha = [startingPointRef.current[0] - clientX, startingPointRef.current[1] - clientY];
            if (opts.direction === 'both' && (Math.abs(alpha[0]) > opts.threshold || Math.abs(alpha[1]) > opts.threshold)) {
                isDraggingRef.current = true;
                var nextState = {
                    alphaX: alpha[0],
                    alphaY: alpha[1],
                    count: state.count,
                    swiping: true,
                    direction: (0, swipeUtils_1.getDirection)([clientX, clientY], startingPointRef.current, alpha)
                };
                if (!isEqual(nextState, state)) {
                    setState(nextState);
                }
            }
            if (opts.direction === 'horizontal' && Math.abs(alpha[0]) > opts.threshold) {
                isDraggingRef.current = true;
                var nextState = {
                    alphaX: alpha[0],
                    alphaY: 0,
                    count: state.count,
                    swiping: true,
                    direction: (0, swipeUtils_1.getHorizontalDirection)(alpha[0])
                };
                if (!isEqual(nextState, state)) {
                    setState(nextState);
                }
            }
            if (opts.direction === 'vertical' && Math.abs(alpha[1]) > opts.threshold) {
                isDraggingRef.current = true;
                var nextState = {
                    alphaY: alpha[1],
                    alphaX: 0,
                    count: state.count,
                    swiping: true,
                    direction: (0, swipeUtils_1.getVerticalDirection)(alpha[1])
                };
                if (!isEqual(nextState, state)) {
                    setState(nextState);
                }
            }
        }
    };
    var endSwipe = function (event) {
        if (isDraggingRef.current) {
            if (opts.preventDefault) {
                event.preventDefault();
                event.stopPropagation();
            }
            setState(function (prevState) { return (__assign(__assign({}, prevState), { swiping: false, count: state.count + 1 })); });
        }
        startingPointRef.current = [-1, -1];
        isDraggingRef.current = false;
    };
    onMouseDown(startSwipe);
    onTouchStart(startSwipe);
    onMouseMove(continueSwipe);
    onTouchMove(continueSwipe);
    onMouseUp(endSwipe);
    onTouchEnd(endSwipe);
    onMouseLeave(endSwipe);
    onTouchCancel(endSwipe);
    return state;
};
exports.default = useSwipe;
