/**
 * The options that can be passed to the hook
 * @see https://developer.mozilla.org/en-US/docs/Web/API/SpeechSynthesisUtterance
 */
export interface UseSpeechSynthesisOptions {
    rate?: number;
    pitch?: number;
    volume?: number;
    voice?: SpeechSynthesisVoice;
}
/**
 * The result of the hook
 */
export interface SpeechSynthesisResult {
    readonly speak: () => void;
    readonly speechSynthUtterance: SpeechSynthesisUtterance;
}
/**
 * Enables the possibility to perform a text-to-speech (with different voices) operation in your
 * React component by using the Web_Speech_API
 */
declare const useSpeechSynthesis: (text: string, options?: UseSpeechSynthesisOptions) => Readonly<SpeechSynthesisResult>;
export default useSpeechSynthesis;
