"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var useQueryParam_1 = __importDefault(require("./useQueryParam"));
/**
 * Ease the process of modify the 'search' query string in the URL for the current location.
 * It's just a shortcut/wrapper around useQueryParam
 */
var useSearchQuery = function (initialValue, replaceState) {
    if (replaceState === void 0) { replaceState = false; }
    return (0, useQueryParam_1.default)('search', {
        initialValue: initialValue,
        replaceState: replaceState
    });
};
exports.default = useSearchQuery;
