"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var getInitial = function (moduleName) { return ({
    module: moduleName,
    renders: 0,
    timestamp: null,
    sinceLast: null
}); };
/**
 * useRenderInfo
 * @param moduleName
 * @param log
 * @returns {{renders: number, module: *, timestamp: null}}
 */
var useRenderInfo = function (moduleName, log) {
    if (moduleName === void 0) { moduleName = 'Unknown component'; }
    if (log === void 0) { log = true; }
    var info = (0, react_1.useRef)(getInitial(moduleName)).current;
    var now = +Date.now();
    info.renders += 1;
    info.sinceLast = info.timestamp ? (now - info.timestamp) / 1000 : '[now]';
    info.timestamp = now;
    if (log) {
        console.group("".concat(moduleName, " info"));
        console.log("Render no: ".concat(info.renders).concat(info.renders > 1 ? ", ".concat(info.sinceLast, "s since last render") : ''));
        console.dir(info);
        console.groupEnd();
    }
    return info;
};
exports.default = useRenderInfo;
