"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
/**
 * On each render returns the previous value of the given variable/constant.
 */
var usePreviousValue = function (value) {
    var prevValue = (0, react_1.useRef)();
    (0, react_1.useEffect)(function () {
        prevValue.current = value;
        return function () {
            prevValue.current = undefined;
        };
    });
    return prevValue.current;
};
exports.default = usePreviousValue;
