"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
/**
 * Returns a reactive value that can be used as a state.
 */
var useMutableState = function (initialState) {
    if (typeof initialState !== 'object' || initialState === null)
        throw new Error('The initial state must be an object');
    var _a = (0, react_1.useState)(0), setState = _a[1];
    return (0, react_1.useMemo)(function () { return new Proxy(initialState, {
        set: function (target, prop, value) {
            if (target && target[prop] !== value) {
                target[prop] = value;
                setState(function (state) { return (state + 1); });
            }
            return true;
        }
    }); }, []);
};
exports.default = useMutableState;
