"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useMouseEvents_1 = __importDefault(require("./useMouseEvents"));
var createStateObject = function (event) { return ({
    clientX: event.clientX,
    clientY: event.clientY,
    screenX: event.screenX,
    screenY: event.screenY
}); };
/**
 * Returns the current state (position) of the mouse pointer.
 * It possibly accepts a DOM ref representing the mouse target.
 * If a target is not provided the state will be caught globally.
 */
var useMouseState = function (targetRef) {
    var _a = (0, react_1.useState)({ clientX: 0, clientY: 0, screenX: 0, screenY: 0 }), state = _a[0], setState = _a[1];
    var onMouseMove = (0, useMouseEvents_1.default)(targetRef).onMouseMove;
    onMouseMove(function (event) {
        var nextState = createStateObject(event);
        setState(nextState);
    });
    return state;
};
exports.default = useMouseState;
