import { type RefObject } from 'react';
/**
 * Returns an array where the first item is the mouse state from the `useMouseState` hook and the second item
 * is the object of callback setters from the `useMouseEvents` hook.
 * It is intended as a shortcut to those hooks.
 */
declare const useMouse: <TElement extends HTMLElement>(targetRef?: RefObject<TElement> | undefined) => ({
    clientX: number;
    clientY: number;
    screenX: number;
    screenY: number;
} | Readonly<{
    onMouseDown: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseEnter: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseLeave: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseMove: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseOut: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseOver: import("./shared/types").CallbackSetter<MouseEvent>;
    onMouseUp: import("./shared/types").CallbackSetter<MouseEvent>;
}>)[];
export default useMouse;
