"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useMouseEvents_1 = __importDefault(require("./useMouseEvents"));
var useConditionalTimeout_1 = __importDefault(require("./useConditionalTimeout"));
var createHandlerSetter_1 = __importDefault(require("./factory/createHandlerSetter"));
var useTouchEvents_1 = __importDefault(require("./useTouchEvents"));
/**
 * A hook that facilitates the implementation of the long press functionality on a given target, supporting both mouse and touch events.
 */
var useLongPress = function (target, duration) {
    if (duration === void 0) { duration = 500; }
    var _a = (0, useMouseEvents_1.default)(target, false), onMouseDown = _a.onMouseDown, onMouseUp = _a.onMouseUp, onMouseLeave = _a.onMouseLeave;
    var _b = (0, useTouchEvents_1.default)(target, false), onTouchStart = _b.onTouchStart, onTouchEnd = _b.onTouchEnd;
    var _c = (0, react_1.useState)(false), isLongPressing = _c[0], setIsLongPressing = _c[1];
    var _d = (0, react_1.useState)(false), timerOn = _d[0], startTimer = _d[1];
    var _e = (0, createHandlerSetter_1.default)(), onLongPressStart = _e[0], setOnLongPressStart = _e[1];
    var _f = (0, createHandlerSetter_1.default)(), onLongPressEnd = _f[0], setOnLongPressEnd = _f[1];
    var longPressStart = (0, react_1.useCallback)(function (event) {
        event.preventDefault();
        startTimer(true);
    }, []);
    var longPressStop = (0, react_1.useCallback)(function (event) {
        if (!isLongPressing)
            return;
        clearTimeout();
        setIsLongPressing(false);
        startTimer(false);
        event.preventDefault();
        if (onLongPressEnd === null || onLongPressEnd === void 0 ? void 0 : onLongPressEnd.current) {
            onLongPressEnd.current();
        }
    }, [isLongPressing]);
    var _g = (0, useConditionalTimeout_1.default)(function () {
        setIsLongPressing(true);
        if (onLongPressStart === null || onLongPressStart === void 0 ? void 0 : onLongPressStart.current) {
            onLongPressStart.current();
        }
    }, duration, timerOn), clearTimeout = _g[1];
    onMouseDown(longPressStart);
    onMouseLeave(longPressStop);
    onMouseUp(longPressStop);
    onTouchStart(longPressStart);
    onTouchEnd(longPressStop);
    return Object.freeze({
        isLongPressing: isLongPressing,
        onLongPressStart: setOnLongPressStart,
        onLongPressEnd: setOnLongPressEnd
    });
};
exports.default = useLongPress;
