"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var useEvent_1 = __importDefault(require("./useEvent"));
var isFunction_1 = __importDefault(require("./shared/isFunction"));
var safeHasOwnProperty_1 = __importDefault(require("./shared/safeHasOwnProperty"));
var createHandlerSetter_1 = __importDefault(require("./factory/createHandlerSetter"));
/**
 * Accepts an HTML Element ref, then returns a function that allows you to handle the infinite
 * scroll for that specific element.
 */
var useInfiniteScroll = function (ref, delay) {
    if (delay === void 0) { delay = 300; }
    var onScroll = (0, useEvent_1.default)(ref, 'scroll', { passive: true });
    var _a = (0, createHandlerSetter_1.default)(), onScrollEnd = _a[0], setOnScrollEnd = _a[1];
    var timeoutRef = (0, react_1.useRef)();
    if (ref && !(0, safeHasOwnProperty_1.default)(ref, 'current')) {
        throw new Error('Unable to assign any scroll event to the given ref');
    }
    onScroll(function (event) {
        var target = event.target;
        var el = target;
        if (el) {
            var isBottom = Math.abs(el.scrollHeight - el.clientHeight - el.scrollTop) < 1;
            // event.preventDefault()
            event.stopPropagation();
            if (isBottom && (0, isFunction_1.default)(onScrollEnd === null || onScrollEnd === void 0 ? void 0 : onScrollEnd.current)) {
                clearTimeout(timeoutRef.current);
                timeoutRef.current = setTimeout(function () {
                    if (onScrollEnd.current && (0, isFunction_1.default)(onScrollEnd.current)) {
                        onScrollEnd.current();
                    }
                    clearTimeout(timeoutRef.current);
                }, delay);
            }
        }
    });
    return setOnScrollEnd;
};
exports.default = useInfiniteScroll;
