"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var useSwipe_1 = __importDefault(require("./useSwipe"));
var defaultOptions = {
    threshold: 15,
    preventDefault: true
};
/**
 * A shortcut to useSwipe (with horizontal options)
 */
var useHorizontalSwipe = function (ref, options) {
    if (options === void 0) { options = defaultOptions; }
    var opts = __assign(__assign(__assign({}, defaultOptions), (options || {})), { direction: 'horizontal' });
    return (0, useSwipe_1.default)(ref, opts);
};
exports.default = useHorizontalSwipe;
