"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var useEvent_1 = __importDefault(require("./useEvent"));
var isClient_1 = __importDefault(require("./shared/isClient"));
var noop_1 = __importDefault(require("./shared/noop"));
/**
 * Accepts an event name then returns a callback setter for a function to be performed when the event triggers.
 */
var useGlobalEvent = function (eventName, opts) {
    if (!isClient_1.default) {
        return noop_1.default;
    }
    var target = { current: window }; // that's a bit of a hack but it works
    return (0, useEvent_1.default)(target, eventName, opts);
};
exports.default = useGlobalEvent;
