import { type BRHGeolocationPosition, type BRHGeolocationPositionError, type SomeCallback } from './shared/types';
export interface GeolocationState {
    readonly isSupported: boolean;
    readonly isRetrieving: boolean;
    readonly position: BRHGeolocationPosition;
}
export interface UseGeolocationStateResult extends GeolocationState {
    onError: (callback: SomeCallback<BRHGeolocationPositionError>) => void;
}
/**
 * Returns a frozen object containing the `position` object, the `isSupported` boolean flag, reporting whether the
 * geolocation API is supported or not and the `isRetrieving` boolean flag reporting whether the hook is fetching the
 * current position.
 * The position is retrieved by using the
 * [Geolocation API](https://developer.mozilla.org/en-US/docs/Web/API/Geolocation_API/Using_the_Geolocation_API),
 * when supported.<br/><br />
 * It possibly accepts an object of [geolocation options]
 * (https://developer.mozilla.org/en-US/docs/Web/API/PositionOptions) to be used as parameter when using the
 * `Geolocation.getCurrentPosition()` method.
 */
declare const useGeolocationState: (options?: PositionOptions) => Readonly<UseGeolocationStateResult>;
export default useGeolocationState;
