"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("react");
var safeHasOwnProperty_1 = __importDefault(require("./shared/safeHasOwnProperty"));
var useEvent_1 = __importDefault(require("./useEvent"));
/**
 * Returns an object of callback setters to handle the drag-related events.
 * It accepts a DOM ref representing the events target (where attach the events to).
 *
 * Returned callback setters: `onDrag`, `onDrop`, `onDragEnter`, `onDragEnd`, `onDragExit`, `onDragLeave`,
 * `onDragOver`, `onDragStart`;
 */
var useDragEvents = function (targetRef, isDraggable) {
    if (isDraggable === void 0) { isDraggable = true; }
    var onDrag = (0, useEvent_1.default)(targetRef, 'drag');
    var onDrop = (0, useEvent_1.default)(targetRef, 'drop');
    var onDragEnter = (0, useEvent_1.default)(targetRef, 'dragenter');
    var onDragEnd = (0, useEvent_1.default)(targetRef, 'dragend');
    var onDragExit = (0, useEvent_1.default)(targetRef, 'dragexit');
    var onDragLeave = (0, useEvent_1.default)(targetRef, 'dragleave');
    var onDragOver = (0, useEvent_1.default)(targetRef, 'dragover');
    var onDragStart = (0, useEvent_1.default)(targetRef, 'dragstart');
    if (targetRef !== null && !(0, safeHasOwnProperty_1.default)(targetRef, 'current')) {
        throw new Error('Unable to assign any drag event to the given ref');
    }
    (0, react_1.useEffect)(function () {
        if (isDraggable && targetRef.current && !targetRef.current.hasAttribute('draggable')) {
            targetRef.current.setAttribute('draggable', String(true));
        }
    }, []);
    return Object.freeze({
        onDrag: onDrag,
        onDrop: onDrop,
        onDragEnter: onDragEnter,
        onDragEnd: onDragEnd,
        onDragExit: onDragExit,
        onDragLeave: onDragLeave,
        onDragOver: onDragOver,
        onDragStart: onDragStart
    });
};
exports.default = useDragEvents;
