import { type GenericFunction } from './shared/types';
/**
 * An async-utility hook that accepts a callback function and a delay time (in milliseconds), then delays the
 * execution of the given function by the defined time from when the condition verifies.
 */
declare const useConditionalTimeout: <TCallback extends GenericFunction>(fn: TCallback, milliseconds: number, condition: boolean, options?: UseConditionalTimeoutOptios) => UseConditionalTimeoutReturn;
export interface UseConditionalTimeoutOptios {
    cancelOnUnmount?: boolean;
    cancelOnConditionChange?: boolean;
}
export type UseConditionalTimeoutReturn = [boolean, () => void];
export default useConditionalTimeout;
