"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useAudio = void 0;
var react_1 = require("react");
var noop_1 = __importDefault(require("./shared/noop"));
var isClient_1 = __importDefault(require("./shared/isClient"));
var useObjectState_1 = __importDefault(require("./useObjectState"));
var isDevelopment_1 = __importDefault(require("./shared/isDevelopment"));
var isAPISupported_1 = __importDefault(require("./shared/isAPISupported"));
var createHandlerSetter_1 = __importDefault(require("./factory/createHandlerSetter"));
var warnOnce_1 = __importDefault(require("./shared/warnOnce"));
/**
 * The default options for the useAudio hook
 */
var defaultOptions = {
    volume: 1,
    loop: false,
    muted: false,
    playbackRate: 1,
    autoPlay: false,
    preload: 'auto'
};
/**
 * The default state for the useAudio hook
 */
var defaultState = __assign({ duration: 0, currentTime: 0, isPlaying: false, isSrcLoading: undefined }, defaultOptions);
/**
 * The error event code to message mapper
 */
var errorEventCodeToMessageMapper = {
    3: 'MEDIA_ERR_DECODE - error occurred when decoding',
    4: 'MEDIA_ERR_SRC_NOT_SUPPORTED - audio not supported',
    2: 'MEDIA_ERR_NETWORK - error occurred when downloading',
    1: 'MEDIA_ERR_ABORTED - fetching process aborted by user',
    0: 'UNKNOWN_ERROR - unknown error'
};
/**
 * The hook not supported controls
 */
var hookNotSupportedControls = Object.freeze({
    seek: noop_1.default,
    play: noop_1.default,
    mute: noop_1.default,
    pause: noop_1.default,
    unmute: noop_1.default,
    onError: noop_1.default,
    setVolume: noop_1.default
});
/**
 * Checks if the ref element exists and calls the callback with it
 * @param ref
 * @param callback
 */
var checkIfRefElementExists = function (ref, callback) { return function () {
    var element = ref.current;
    if (!element) {
        return undefined;
    }
    return callback(element);
}; };
/**
 * The useAudio hook wraps the Audio API and provides a set of controls to manage the audio
 */
var useAudio = function (src, options) {
    var hookNotSupportedResponse = [
        defaultState,
        hookNotSupportedControls,
        (0, react_1.useRef)(null)
    ];
    if (!isClient_1.default) {
        if (!isDevelopment_1.default) {
            (0, warnOnce_1.default)('Please be aware that useAudio hook could not be available during SSR');
        }
        return hookNotSupportedResponse;
    }
    if (!(0, isAPISupported_1.default)('Audio')) {
        (0, warnOnce_1.default)('The current device does not support the \'Audio\' API, you should avoid using useAudio hook');
        return hookNotSupportedResponse;
    }
    var audioRef = (0, react_1.useRef)(new Audio(src));
    var _a = (0, createHandlerSetter_1.default)(), onErrorRef = _a[0], setOnErrorRef = _a[1];
    var _b = (0, useObjectState_1.default)(defaultState), state = _b[0], setState = _b[1];
    var onError = function (error) {
        if (onErrorRef.current != null) {
            onErrorRef.current(error);
        }
    };
    var play = (0, react_1.useCallback)(checkIfRefElementExists(audioRef, function (element) { return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, element
                        .play()
                        .then(function () {
                        setState({
                            isPlaying: true
                        });
                    })
                        .catch(onError)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); }), []);
    var pause = (0, react_1.useCallback)(checkIfRefElementExists(audioRef, function (element) {
        element.pause();
        setState({
            isPlaying: false
        });
    }), []);
    var mute = (0, react_1.useCallback)(checkIfRefElementExists(audioRef, function (element) {
        // eslint-disable-next-line no-param-reassign
        element.muted = true;
        setState({
            muted: true
        });
    }), []);
    var unmute = (0, react_1.useCallback)(checkIfRefElementExists(audioRef, function (element) {
        // eslint-disable-next-line no-param-reassign
        element.muted = false;
        setState({
            muted: false
        });
    }), []);
    var seek = (0, react_1.useCallback)(function (time) { return checkIfRefElementExists(audioRef, function (element) {
        var newTime = time >= 0 ? Math.min(time, element.duration) : Math.max(time, 0);
        // eslint-disable-next-line no-param-reassign
        element.currentTime = newTime;
        setState({
            currentTime: newTime
        });
    })(); }, []);
    var setVolume = (0, react_1.useCallback)(function (volume) { return checkIfRefElementExists(audioRef, function (element) {
        var newVolume = volume >= 0 ? Math.min(volume, 1) : Math.max(volume, 0);
        // eslint-disable-next-line no-param-reassign
        element.volume = newVolume;
        setState({
            volume: newVolume
        });
    })(); }, []);
    var onLoadedData = checkIfRefElementExists(audioRef, function (element) {
        setState({
            isSrcLoading: false,
            duration: element.duration,
            currentTime: element.currentTime
        });
    });
    var onTimeUpdate = checkIfRefElementExists(audioRef, function (element) {
        setState({
            currentTime: element.currentTime
        });
    });
    var errorEventCallback = function () {
        var _a, _b, _c;
        var element = audioRef.current;
        var errorCode = (_a = element.error) === null || _a === void 0 ? void 0 : _a.code;
        var errorMessage = ((_c = (_b = element.error) === null || _b === void 0 ? void 0 : _b.message) !== null && _c !== void 0 ? _c : errorEventCodeToMessageMapper[errorCode !== null && errorCode !== void 0 ? errorCode : 0]) || 'UNKNOWN';
        onError(new Error(errorMessage));
    };
    (0, react_1.useEffect)(function () {
        var element = audioRef.current;
        if (element) {
            var mergedOptions = __assign(__assign({}, defaultOptions), options);
            element.loop = mergedOptions.loop;
            element.muted = mergedOptions.muted;
            element.volume = mergedOptions.volume;
            element.preload = mergedOptions.preload;
            element.autoplay = mergedOptions.autoPlay;
            element.playbackRate = mergedOptions.playbackRate;
            setState(__assign(__assign({}, mergedOptions), { isSrcLoading: true }));
            element.addEventListener('loadeddata', onLoadedData);
            element.addEventListener('timeupdate', onTimeUpdate);
            element.addEventListener('error', errorEventCallback);
        }
        return function () {
            if (element) {
                element.removeEventListener('loadeddata', onLoadedData);
                element.removeEventListener('timeupdate', onTimeUpdate);
                element.removeEventListener('error', errorEventCallback);
            }
            pause();
        };
    }, []);
    (0, react_1.useEffect)(function () {
        if (state.isSrcLoading === false && state.autoPlay) {
            play();
        }
    }, [state.isSrcLoading, state.autoPlay]);
    var controls = Object.freeze({
        seek: seek,
        play: play,
        mute: mute,
        pause: pause,
        unmute: unmute,
        setVolume: setVolume,
        onError: setOnErrorRef
    });
    return [state, controls, audioRef];
};
exports.useAudio = useAudio;
exports.default = exports.useAudio;
