import { type MutableRefObject } from 'react';
/**
 * The useAudio hook wraps the Audio API and provides a set of controls to manage the audio
 */
export declare const useAudio: (src: string, options?: UseAudioOptions) => [AudioState, Readonly<AudioControls>, MutableRefObject<HTMLAudioElement>];
type UseAudioPreloadType = 'auto' | 'metadata' | 'none';
/**
 * The interface for the state of the useAudio hook
 */
export interface AudioState {
    loop: boolean;
    muted: boolean;
    volume: number;
    duration: number;
    autoPlay: boolean;
    isPlaying: boolean;
    preload?: UseAudioPreloadType;
    currentTime: number;
    playbackRate: number;
    isSrcLoading: boolean | undefined;
}
/**
 * The interface for the options of the useAudio hook
 */
export interface UseAudioOptions {
    loop?: boolean;
    muted?: boolean;
    volume?: number;
    autoPlay?: boolean;
    preload?: UseAudioPreloadType;
    playbackRate?: number;
}
/**
 * The interface for the controls of the useAudio hook
 */
export interface AudioControls {
    play: () => void;
    mute: () => void;
    pause: () => void;
    unmute: () => void;
    seek: (time: number) => void;
    onError: (onError: ((error: Error) => void)) => void;
    setVolume: (volume: number) => void;
}
export default useAudio;
