"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDirection = exports.getVerticalDirection = exports.getHorizontalDirection = exports.getPointerCoordinates = void 0;
/**
 * Takes a mouse or a touch events and returns clientX and clientY values
 * @param event
 * @return {[undefined, undefined]}
 */
var getPointerCoordinates = function (event) {
    if (event.touches) {
        var _a = event.touches[0], clientX_1 = _a.clientX, clientY_1 = _a.clientY;
        return [clientX_1, clientY_1];
    }
    var _b = event, clientX = _b.clientX, clientY = _b.clientY;
    return [clientX, clientY];
};
exports.getPointerCoordinates = getPointerCoordinates;
var getHorizontalDirection = function (alpha) { return (alpha < 0 ? 'right' : 'left'); };
exports.getHorizontalDirection = getHorizontalDirection;
var getVerticalDirection = function (alpha) { return (alpha < 0 ? 'down' : 'up'); };
exports.getVerticalDirection = getVerticalDirection;
var getDirection = function (currentPoint, startingPoint, alpha) {
    var alphaX = startingPoint[0] - currentPoint[0];
    var alphaY = startingPoint[1] - currentPoint[1];
    if (Math.abs(alphaX) > Math.abs(alphaY)) {
        return (0, exports.getHorizontalDirection)(alpha[0]);
    }
    return (0, exports.getVerticalDirection)(alpha[1]);
};
exports.getDirection = getDirection;
