import { useCallback, useReducer } from 'react';
const reducer = (previousState, updatedState) => (Object.assign(Object.assign({}, previousState), updatedState));
const useObjectState = (initialState) => {
    const [state, dispatch] = useReducer((previousState, updatedState) => reducer(previousState, updatedState), initialState);
    const setState = useCallback((updatedState) => { dispatch(updatedState); }, [dispatch]);
    return [state, setState];
};
export default useObjectState;
