var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { useCallback, useEffect, useState } from 'react';
import noop from './shared/noop';
import isClient from './shared/isClient';
import isDevelopment from './shared/isDevelopment';
import isAPISupported from './shared/isAPISupported';
import createHandlerSetter from './factory/createHandlerSetter';
import warnOnce from './shared/warnOnce';
const useCookie = (key, options) => {
    const hookNotSupportedResponse = Object.freeze({
        onError: noop,
        updateCookie: noop,
        deleteCookie: noop,
        cookieValue: options === null || options === void 0 ? void 0 : options.defaultValue
    });
    if (!isClient) {
        if (!isDevelopment) {
            warnOnce('Please be aware that cookieStore could not be available during SSR');
        }
        return hookNotSupportedResponse;
    }
    if (!isAPISupported('cookieStore')) {
        warnOnce('The current device does not support the \'cookieStore\' API, you should avoid using useCookie');
        return hookNotSupportedResponse;
    }
    const [cookieValue, setCookieValue] = useState();
    const [onErrorRef, setOnErrorRef] = createHandlerSetter();
    const cookieStoreObject = window.cookieStore;
    const onError = (err) => {
        if (onErrorRef.current != null) {
            onErrorRef.current(err);
        }
    };
    useEffect(() => {
        const getInitialValue = () => __awaiter(void 0, void 0, void 0, function* () {
            try {
                const getFunctionResult = yield cookieStoreObject.get(key);
                if (getFunctionResult === null || getFunctionResult === void 0 ? void 0 : getFunctionResult.value) {
                    setCookieValue(getFunctionResult.value);
                    return;
                }
                yield cookieStoreObject.set(Object.assign({ name: key, value: options === null || options === void 0 ? void 0 : options.defaultValue }, options));
                setCookieValue(options === null || options === void 0 ? void 0 : options.defaultValue);
                return;
            }
            catch (err) {
                onError(err);
            }
        });
        getInitialValue().catch(onError);
    }, []);
    const updateCookie = useCallback((newValue) => __awaiter(void 0, void 0, void 0, function* () {
        yield cookieStoreObject
            .set(Object.assign({ name: key, value: newValue }, options))
            .then(() => {
            setCookieValue(newValue);
        })
            .catch(onError);
    }), []);
    const deleteCookie = useCallback(() => __awaiter(void 0, void 0, void 0, function* () {
        yield cookieStoreObject
            .delete(Object.assign({ name: key }, options))
            .then(() => {
            setCookieValue(undefined);
        })
            .catch(onError);
    }), []);
    return Object.freeze({
        cookieValue,
        updateCookie,
        deleteCookie,
        onError: setOnErrorRef
    });
};
export var CookieSameSite;
(function (CookieSameSite) {
    CookieSameSite["STRICT"] = "strict";
    CookieSameSite["LAX"] = "lax";
    CookieSameSite["NONE"] = "none";
})(CookieSameSite || (CookieSameSite = {}));
export default useCookie;
